/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rcs.inconn;

import com.ibm.hwmca.base.rcs.inconn.AutoCallAnswerBean;
import com.ibm.hwmca.base.rcs.inconn.AutoCallAnswerConstants;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigManager;
import com.ibm.hwmca.fw.rcs.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class AutoCallAnswerTasklet
extends PanelTasklet
implements InboundConnectivityConstants,
AutoCallAnswerConstants {
    private static final String TRACE_MASKT = "XRCSAATT";
    private static final String TRACE_MASKF = "XRCSAATF";
    private static final String TRACE_MASKD = "XRCSAATD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-AutATskl");
    private InboundConfigData inConfigData;
    private String taskletRequestId = this.toString();
    private int taskletRequestNum = 0;
    private AutoCallAnswerBean autoCallAnswerBean;

    public AutoCallAnswerTasklet() {
        Trace.trace(TRACE_MASKT, "<> AutoCallAnswerTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> destroy()");
        super.destroy();
        Trace.trace(TRACE_MASKT, "<- destroy()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.autoCallAnswerBean = new AutoCallAnswerBean();
                this.autoCallAnswerBean.setBeanName("AutoCallAnswerBean");
                InboundConfigManager inConfigMgr = InboundConfigManager.getInboundConfigManager();
                this.inConfigData = inConfigMgr.getInboundConfig();
                this.autoCallAnswerBean.setAutoCallAnswer(this.inConfigData.isAllowUnattendedService());
                this.autoCallAnswerBean.setModemPhoneNumber(this.inConfigData.getModemPhoneNumber());
                this.autoCallAnswerBean.setLoginName(this.inConfigData.getUnattendedUserName());
                this.autoCallAnswerBean.setPassword(this.inConfigData.getUnattendedPassword());
                this.autoCallAnswerBean.setConfirmPassword(this.inConfigData.getUnattendedPassword());
                response.replace("com.ibm.hwmca.base.rcs.inconn.res.AutoCallAnswerRes", "AutoCallAnswerPanel", this.autoCallAnswerBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source == null || source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("AutoCallAnswerPanel")) {
                    this.serviceAutoCallAnswerPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceAutoCallAnswerPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceAutoCallAnswerPanel()");
        String command = (String)request.getData("Command");
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command == null || command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            AutoCallAnswerBean bean = (AutoCallAnswerBean)request.getData("Bean");
            if (bean != null) {
                this.inConfigData.setAllowUnattendedService(bean.isAutoCallAnswer());
                this.inConfigData.setModemPhoneNumber(bean.getModemPhoneNumber());
                this.inConfigData.setUnattendedUserName(bean.getLoginName());
                this.inConfigData.setUnattendedPassword(bean.getPassword());
                InboundConfigManager inConfigMgr = InboundConfigManager.getInboundConfigManager();
                inConfigMgr.setInboundConfig(this.inConfigData);
            }
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceAutoCallAnswerPanel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletRequestId() {
        AutoCallAnswerTasklet autoCallAnswerTasklet = this;
        synchronized (autoCallAnswerTasklet) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.taskletRequestId);
            sb.append("-");
            sb.append(++this.taskletRequestNum);
            return sb.toString();
        }
    }
}

